import { json } from '@sveltejs/kit';
import { db } from '$lib/server/db.js';

/** @type {import('./$types').RequestHandler} */
export async function GET({ params }) {
  try {
    const id = parseInt(params.id);
    const [classes] = await db.query('SELECT * FROM classes WHERE id = ?', [id]);
    
    if (classes.length === 0) {
      return json({ error: 'Kelas tidak ditemukan' }, { status: 404 });
    }
    
    return json({ success: true, data: classes[0] });
  } catch (error) {
    console.error('Get class error:', error);
    return json({ error: 'Gagal mengambil data kelas' }, { status: 500 });
  }
}

/** @type {import('./$types').RequestHandler} */
export async function PUT({ params, request }) {
  try {
    const id = parseInt(params.id);
    const data = await request.json();
    const { name, major, homeroomTeacher, studentCount, status } = data;

    if (!name) {
      return json({ error: 'Nama kelas wajib diisi' }, { status: 400 });
    }

    await db.query(
      `UPDATE classes 
       SET name = ?, major = ?, homeroomTeacher = ?, studentCount = ?, status = ?
       WHERE id = ?`,
      [name.trim(), major || null, homeroomTeacher || null, studentCount || 0, status || 'aktif', id]
    );

    return json({ success: true, message: 'Kelas berhasil diupdate' });
  } catch (error) {
    console.error('Update class error:', error);
    return json({ error: 'Gagal mengupdate kelas' }, { status: 500 });
  }
}

/** @type {import('./$types').RequestHandler} */
export async function DELETE({ params }) {
  try {
    const id = parseInt(params.id);
    await db.query('DELETE FROM classes WHERE id = ?', [id]);
    return json({ success: true, message: 'Kelas berhasil dihapus' });
  } catch (error) {
    console.error('Delete class error:', error);
    return json({ error: 'Gagal menghapus kelas' }, { status: 500 });
  }
}
